unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Printers;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Edit2: TEdit;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    procedure SetPrinterPage(Width, Height: Integer);
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.SetPrinterPage(Width, Height : LongInt);
var
  Device : array[0..255] of char;
  Driver : array[0..255] of char;
  Port   : array[0..255] of char;
  hDMode : THandle;
  PDMode : PDEVMODE;
begin
// obtm o DEVMODE atual
  Printer.GetPrinter(Device, Driver, Port, hDMode);
  if hDMode <> 0 then begin
// trava a memria apontada por PDMODE, para alterar
    pDMode := GlobalLock( hDMode );
// altera campos de altura e largura
    if pDMode <> nil then begin
      pDMode^.dmPaperSize   := DMPAPER_USER;
      pDMode^.dmPaperWidth  := Width;
      pDMode^.dmPaperLength := Height;
      pDMode^.dmFields := pDMode^.dmFields or
        DM_PAPERSIZE;
      GlobalUnlock( hDMode );
    end;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if (Edit1.Text <> '') and (Edit2.Text <> '') then
  try
    SetPrinterPage(StrToInt(Edit1.Text),StrToInt(Edit2.Text));
    with Printer do begin
      BeginDoc;
      try
        Canvas.TextOut(600,600,'Este  um teste');
      finally
        EndDoc;
      end;
    end;
  except
   On EConvertError do
     MessageDlg('Valores invlidos',mtError,[mbOk],0);
  end;
end;

end.
